package ws.afterglo.audioPod;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;

import javax.swing.JOptionPane;

/**
 * @author muti
 * modified by philippe
 * 
 */
public class AudioPod {
    public static UI		UI;
    public static ArrayList	recentplayed; //parsed using DbReader class
    public static ArrayList	toSubmit;
    public static Scrobbler	scrobbler;
    public static IScrobbler is;
    public static WaScrobbler wa;
    public static String iTunesPath;
    public static boolean iTEnabled=false;
    public static String winampPath;
    public static boolean waEnabled=false;
    public static String iTDBPath;
    public static String APPath;
    public static String waCachePath;
    public static String defaultPlayer;
    public static String  hddrive;
    public static boolean ce;
    public static boolean caching;
    public static boolean cacheAndExitiT=false;
    public static boolean cacheAndExitWa=false;
    public static boolean hdmounted=false;
    public static boolean delPlaysEnabled=false;
    public static boolean selectEnabled=false;
    public static int[] selectedTracks;
    
    public static int iTunesCount;
    public static int winampCount;
    public static int iPodCount;
    public static int totalCount;
    public static int iPodShortCount;
    
    public static Logger    logger;
    public static String    NoPrefsError = "You have not setup your preferences.\n" +
                                           "Please click Preferences below to configure them.";
    
    public static void Load() {
        AudioPod.recentplayed = new ArrayList();
        AudioPod.UI = new UI();
        AudioPod.UI.buildUI();
        
        logger = Logger.getLogger(AudioPod.class.getPackage().getName());
        logger.setLevel(Level.ALL);
        logger.addHandler(new LogHandler());
        
        AudioPod.ParsePlayCounts();
        
        if(cacheAndExitiT){
        	boolean iTLaunch=false;
        	AudioPod.toSubmit=AudioPod.recentplayed;
        	if(caching){
        		AudioPod.ReadPreferences();
        		iTLaunch=is.writeCache();
        		if(AudioPod.waEnabled)
        			WaScrobbler.clearCache();
        	}
        	if(iTLaunch){
        		boolean hdready=false;
        		if(AudioPod.hdmounted){
        			File f=new File(AudioPod.hddrive+":\\");
        			if(f.isDirectory())
        				hdready=true;
        		}
        		if(!AudioPod.hdmounted || (AudioPod.hdmounted && hdready)){
            		try{
            			Runtime rt = Runtime.getRuntime();
            			rt.exec(AudioPod.iTunesPath);
           			}catch(IOException e){}
        		}
            	if(AudioPod.delPlaysEnabled){
            		File f=new File(AudioPod.iTDBPath.charAt(0)+":\\iPod_Control\\iTunes\\Play Counts");
            		if(f.isFile())
            			f.delete();
            	} 
        	}
        	System.exit(0);
        }
        
        if(cacheAndExitWa){
        	boolean waLaunch=false;
        	AudioPod.toSubmit=AudioPod.recentplayed;
        	if(caching){
        		AudioPod.ReadPreferences();
        		waLaunch=wa.writeCache();
        		if(AudioPod.iTEnabled)
        			IScrobbler.clearCache();
        	}
        	if(waLaunch){
        		boolean hdready=false;
        		if(AudioPod.hdmounted){
        			File f=new File(AudioPod.hddrive+":\\");
        			if(f.isDirectory())
        				hdready=true;
        		}
        		if(!AudioPod.hdmounted || (AudioPod.hdmounted && hdready)){
            		try{
            			Runtime rt = Runtime.getRuntime();
            			rt.exec(AudioPod.winampPath);
           			}catch(IOException e){}
        		}
            	if(AudioPod.delPlaysEnabled){
            		File f=new File(AudioPod.iTDBPath.charAt(0)+":\\iPod_Control\\iTunes\\Play Counts");
            		if(f.isFile())
            			f.delete();
            	} 
        	}
        	System.exit(0);
        }
    }
    
    public static void ReadPreferences(){
        Preferences fPrefs = Preferences.userRoot().node("ws/afterglo/audioPod");
        iTDBPath = fPrefs.get("iTunes Path", "default");
        APPath = fPrefs.get("AllPlays Path", "default");
        waCachePath=fPrefs.get("wa Path", "default")+"\\plugins\\audioscrobbler.99.cache";
        winampPath=fPrefs.get("wa Path", "default")+"\\winamp.exe";
        defaultPlayer=fPrefs.get("default player", "iTunes");
        if(fPrefs.get("delPlays", "Disabled").equals("Enabled"))
        	delPlaysEnabled=true;
        else
        	delPlaysEnabled=false;
        if(fPrefs.get("Winamp Status", "Disabled").equals("Enabled"))
        	waEnabled=true;
        else
        	waEnabled=false;
        if(fPrefs.get("iTunes Status", "Disabled").equals("Enabled"))
        	iTEnabled=true;
        else
        	iTEnabled=false;
        if(fPrefs.get("Selected Status", "Disabled").equals("Enabled"))
        	selectEnabled=true;
        else
        	selectEnabled=false;
        iTunesPath=fPrefs.get("iT Path", "default");
        if(iTunesPath.endsWith("iTunes.exe"))
        	AudioPod.iTunesPath=iTunesPath;
        else if(!iTunesPath.equals("default"))
        	iTunesPath+="\\iTunes.exe";
        AudioPod.ce=fPrefs.get("ceCheck", "default").equals("Enabled");
    }
    
    public static void ParsePlayCounts() {
        AudioPod.ReadPreferences();
    	//make sure all global counter variables ar set to 0
    	iTunesCount=0;
        winampCount=0;
        iPodCount=0;
        totalCount=0;
        iPodShortCount=0;
        logger.log(Level.INFO,"*** Reading played & cached tracks ***");
        
        //Do iPod work
    	AudioPod.ParseiPodPlayCounts();
    	
    	//Do iScrobbler work
    	if(AudioPod.iTEnabled){
            is=new IScrobbler();
            try{
            	is.parseCacheFile();
            }catch(Exception e){
            	logger.log(Level.SEVERE,"Unable to read iScrobbler cache");
            }
            is.addIpodSongs();
            AudioPod.recentplayed=is.getCachedTracks();
            logger.log(Level.INFO,AudioPod.iTunesCount+" tracks found in iScrobbler cache");
    	}
    	
        //Do Winamp work
    	if(AudioPod.waEnabled){
            wa=new WaScrobbler(UI);
    		wa.parseCache();
    		wa.addToOtherSongs();
    		AudioPod.recentplayed=wa.getCachedTracks();
    		logger.log(Level.INFO,AudioPod.winampCount+" tracks found in Winamp cache");
    	}
    	
    	AudioPod.totalCount=AudioPod.recentplayed.size();
    	
    	if(AudioPod.totalCount<AudioPod.iTunesCount+AudioPod.iPodCount-AudioPod.iPodShortCount+AudioPod.winampCount)
    		logger.log(Level.INFO,"Some songs are located in multiple caches");
        
        if(AudioPod.totalCount==0){
       		UI.disableCacheB();
        	UI.disableSubmitB();
       		logger.log(Level.INFO,"No tracks found at all!");
       	}else{
       		UI.enableCacheB();
        	UI.enableSubmitB();
        	logger.log(Level.INFO,"A total of "+AudioPod.totalCount+" tracks has been found");
       	}
    	AudioPod.UI.newTrackListAvailable();
    }
    
    public static void ParseiPodPlayCounts() {
        DbReader reader = new DbReader(iTDBPath);
        	try{
        		reader.parse();
        		AudioPod.recentplayed = reader.getRecentplays();
        		logger.log(Level.INFO,AudioPod.iPodCount+" tracks found on iPod");
                if(AudioPod.iPodShortCount>0)
                	logger.log(Level.INFO,(AudioPod.iPodShortCount)+
        			" tracks on the iPod which are shorter then 30 seconds. These will not be submitted");
        	}catch(IOException e){
        		logger.log(Level.SEVERE, "Error reading iTunes database: No iPod plugged in, " +
        				"wrong path or playcount empty.");
        	}
    }
    
    public static boolean SubmitTracks() {
    	boolean succ=false;
        Preferences fPrefs = Preferences.userRoot().node("ws/afterglo/audioPod");
        String username = fPrefs.get("Username", "default");
        String password = fPrefs.get("Password", "default");
        
        if(username.equals("default") && password.equals("default")) {
            logger.log(Level.INFO, AudioPod.NoPrefsError);
            return succ;
        }
        
        try {
            AudioPod.scrobbler = new Scrobbler(username, password, UI);
            AudioPod.scrobbler.handshake();
            AudioPod.scrobbler.submittracks();
            //AudioPod.recentplayed = new ArrayList(); //clear recent track list
            IScrobbler.clearCache(); //clear iScrobbler cache
            succ=true;
        } //catch(UnknownHostException e){
        	
        catch (Exception e) {
            StackTraceElement[] trace = e.getStackTrace();
            for(int i=0; i < trace.length; i++) {
                if(trace[i].getClassName().startsWith("ws.afterglo.audioPod")) {
                    logger.log(Level.SEVERE, trace[i].toString());
                }
            }
            logger.log(Level.SEVERE, e.toString());
            if(e.getMessage().equals("post.audioscrobbler.com"))
            	JOptionPane.showMessageDialog(null, "The server is currently unreachable.\nPlease try again later","Error!", JOptionPane.ERROR_MESSAGE);
            else
            	JOptionPane.showMessageDialog(null, e.getMessage(),"Error!", JOptionPane.ERROR_MESSAGE);
        }
        return succ;
    }
    
    public static boolean ToiScrobbler(){
    	boolean succ=false;
    	try{
    		if((AudioPod.selectEnabled && AudioPod.toSubmit.size()!=0) || !AudioPod.selectEnabled){
    			succ=is.writeCache();
    		}
    		else
    			JOptionPane.showMessageDialog(null, "No tracks selected","Info", JOptionPane.INFORMATION_MESSAGE);
    	}catch(RuntimeException e){
    		JOptionPane.showMessageDialog(null, e.getMessage(),"Error!", JOptionPane.ERROR_MESSAGE);
    	}
    	return succ;
    }
    
    public static boolean ToAllPlays(){
    	boolean succ=false;
    	try{
    		if((AudioPod.selectEnabled && AudioPod.toSubmit.size()!=0) || !AudioPod.selectEnabled){
    			succ=is.writeAllPlays();
    		}
    		else
    			JOptionPane.showMessageDialog(null, "No tracks selected","Info", JOptionPane.INFORMATION_MESSAGE);
    	}catch(RuntimeException e){
    		JOptionPane.showMessageDialog(null, e.getMessage(),"Error!", JOptionPane.ERROR_MESSAGE);
    	}
    	return succ;
    }
    
    public static boolean ToWinamp(){
    	boolean succ=false;
    	try{
    		succ=wa.writeCache();
    	}catch(RuntimeException e){
    		JOptionPane.showMessageDialog(null, e.getMessage(),"Error!", JOptionPane.ERROR_MESSAGE);
    	}
    	return succ;
    }
    
    public static void main(String args[]) {
    	if(args.length>0){
    		for(int i=0;i<args.length;i++){
    			if(i+2<=args.length && args[i].equalsIgnoreCase("-cacheandexit") && args[++i].length()==1){
    				if(args[i].equalsIgnoreCase("i"))
    					cacheAndExitiT=true;
    				else if(args[i].equalsIgnoreCase("w"))
    					cacheAndExitWa=true;
    			}
    			if(i+2<=args.length && args[i].equalsIgnoreCase("-hdmounted") && args[++i].length()==1){
    				hdmounted=true;
    				hddrive=args[i];
    			}
    		}
    	}
        javax.swing.SwingUtilities.invokeLater(new Runnable() {
            public void run() {
                AudioPod.Load();
            }
        });
    }
}
